# 画面設計書 55-メール通知（テキスト - デフォルト）

## 概要

本ドキュメントは、Symfony 8.1のTwig Bridgeが提供するデフォルトスタイルのテキスト形式メール通知テンプレート（`default/notification/body.txt.twig`）の画面設計書である。このテンプレートは、SymfonyのNotifierコンポーネントと連携してプレーンテキスト形式の通知メールを生成する。HTML形式のテンプレート（No.54）と対になるテキスト版であり、HTMLメールを表示できないメールクライアント向けのフォールバックコンテンツとして機能する。

### 本画面の処理概要

**業務上の目的・背景**：メール通知をマルチパート（HTML + テキスト）で送信することは、メール配信のベストプラクティスである。HTMLメールを表示できない環境（テキストのみのメールクライアント、スクリーンリーダー等）や、ユーザーの設定によりテキスト表示が選択されている場合に、本テンプレートが使用される。デフォルトテーマのテキストテンプレートは、Zurb 2テーマのテキストテンプレート（No.57）を継承しており、最小限の構造でメールの内容をプレーンテキストとして出力する。

**画面へのアクセス方法**：本テンプレートはWebブラウザでアクセスするものではなく、メールクライアントでテキスト表示されるコンテンツとして受信される。`NotificationEmail`クラスを使用してメールを送信すると、`getTextTemplate()`メソッドにより本テンプレートが自動的にレンダリングされ、メールのテキストパートとなる。

**主要な操作・処理内容**：
1. メール件名の出力 - `email.subject`変数を使用して通知メールの件名をプレーンテキストで出力する
2. コンテンツ本文の出力 - `content`変数の内容をプレーンテキストとして出力する
3. アクションリンクの出力 - `action_url`と`action_text`が指定されている場合、「テキスト: URL」形式でリンク情報を出力する
4. 例外情報の出力 - 例外が添付されている場合、スタックトレースが添付されている旨のメッセージと例外情報をテキストで出力する

**画面遷移**：テキスト形式のメールのため、リンクURLはテキストとして表示されるのみである。ユーザーがURLをコピーしてブラウザに貼り付けることで遷移可能。

**権限による表示制御**：HTML版（No.54）と同様に、`markAsPublic()`メソッドによる制御が可能である。ただし、テキスト版では重要度ラベルやフッターのブロックは定義されていないため、デフォルトのテキスト出力では`importance`やfooter_textは表示されない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 41 | Notifier | 主機能 | Notifierコンポーネントからのメール通知トリガーによるテキストメールテンプレートのレンダリング |
| 40 | Mailer | 補助機能 | Mailerコンポーネントによるメール送信処理 |
| 42 | Mime | 補助機能 | MIMEメッセージとしてのテキストメール本文構成 |
| 36 | Twig Bridge | 主機能 | Twig Bridgeのメール通知テンプレートによるテキストレンダリング |

## 画面種別

メールテンプレート（テキスト形式メール通知）

## URL/ルーティング

本テンプレートはWebルーティングではなく、Twigテンプレートパスで参照される。

| パス | 説明 |
|-----|------|
| `@email/default/notification/body.txt.twig` | デフォルトテーマのテキストメール通知テンプレート |
| `@email/zurb_2/notification/body.txt.twig` | 実際のテキストレイアウト定義（継承元） |

## 入出力項目

| 変数名 | 型 | 必須 | デフォルト値 | 説明 |
|--------|-----|------|-------------|------|
| email.subject | string | Yes | - | メール件名 |
| content | string | No | `''` | メール本文コンテンツ |
| action_url | string/null | No | `null` | アクションリンク先URL |
| action_text | string/null | No | `null` | アクションリンクテキスト |
| exception | bool/string | No | `false` | 例外情報（例外スタックトレース文字列） |

## 表示項目

| 表示セクション | 出力形式 | 説明 |
|---------------|---------|------|
| メール件名 | プレーンテキスト（leadブロック） | `email.subject`をそのままテキスト出力 |
| コンテンツ本文 | プレーンテキスト（contentブロック） | `content`変数の内容をそのまま出力 |
| アクションリンク | `{action_text}: {action_url}` 形式 | テキスト形式でURLを表示 |
| 例外通知 | `Exception stack trace attached.\n{exception}` | 例外メッセージとスタックトレースをテキスト出力 |

## イベント仕様

### 1-メール送信トリガー

`NotificationEmail`クラスのインスタンスが`Mailer`コンポーネントを通じて送信される際に、`getTextTemplate()`メソッドがテキストテンプレートパスを返し、Twig Environmentがレンダリングを実行する。テキストパートはHTMLパートと共にマルチパートMIMEメッセージとして構成される。

### 2-アクションリンクの条件出力

`action_url`変数が真（非null・非空）の場合のみ、アクションリンク情報が出力される。テキスト形式では「テキスト: URL」のシンプルな形式で表示される。

### 3-例外情報の条件出力

`exception`変数が真の場合、「Exception stack trace attached.」のメッセージに続いて例外情報がテキストとして出力される。

## データベース更新仕様

### 操作別データベース影響一覧

本テンプレートはメールのテキスト生成のみを担当し、データベース操作は行わない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし |

## メッセージ仕様

| メッセージ種別 | 表示条件 | 表示形式 | 内容 |
|---------------|---------|---------|------|
| 例外通知メッセージ | `exception == true` | プレーンテキスト | `Exception stack trace attached.` |

## 例外処理

本テンプレート自体には例外処理は含まない。テンプレートの読み込みに失敗した場合は、Twigのテンプレートローダーが例外をスローする。

## 備考

- デフォルトテーマのテキストテンプレート（`default/notification/body.txt.twig`）は1行のみで、Zurb 2テーマのテキストテンプレート（`zurb_2/notification/body.txt.twig`）を`{% extends %}`で継承している
- HTML版とは異なり、InkyやCSSインライン化の処理は不要であるため、テキストテンプレートはシンプルなTwigブロック構造のみで構成される
- テキスト版では`importance`や`footer_text`を出力するブロックは定義されていないため、これらの情報はテキスト版には含まれない
- `exception`変数はブロック内でスタックトレース文字列として直接出力される（`{{ exception }}`）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

`NotificationEmail`クラスのコンテキスト変数と`getTextTemplate()`の仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | NotificationEmail.php | `src/Symfony/Bridge/Twig/Mime/NotificationEmail.php` | `getTextTemplate()`メソッド（行159-166）で`@email/{theme}/notification/body.txt.twig`が返される。コンテキスト変数（行33-42）のうちテキスト版で使用されるのはcontent、action_url、action_text、exceptionのみ |

**読解のコツ**: テキストテンプレートでは`importance`、`markdown`、`raw`、`footer_text`が使用されない点に注意。HTML版とテキスト版で出力される情報に差異がある。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | body.txt.twig（default） | `src/Symfony/Bridge/Twig/Resources/views/Email/default/notification/body.txt.twig` | デフォルトテーマのエントリーポイント。1行のみでzurb_2/notification/body.txt.twigを継承 |

**主要処理フロー**:
1. **行1**: `{% extends '@email/zurb_2/notification/body.txt.twig' %}` - Zurb 2テーマの継承

#### Step 3: Zurb 2テーマのテキスト実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | body.txt.twig（zurb_2） | `src/Symfony/Bridge/Twig/Resources/views/Email/zurb_2/notification/body.txt.twig` | 実際のテキストレイアウト定義（21行）。4つのTwigブロックで構成 |

**主要処理フロー**:
1. **行1-3**: leadブロック - `{{ email.subject }}`でメール件名を出力
2. **行5-7**: contentブロック - `{{ content }}`でコンテンツ本文を出力
3. **行9-13**: actionブロック - `action_url`指定時に`{{ action_text }}: {{ action_url }}`を出力
4. **行15-21**: exceptionブロック - 例外時に通知メッセージと`{{ exception }}`を出力

### プログラム呼び出し階層図

```
NotificationEmail::send()
    |
    +-- Mailer（メール送信処理）
    |       |
    |       +-- BodyRenderer（テンプレートレンダリング）
    |               |
    |               +-- Twig Environment
    |                       |
    |                       +-- body.txt.twig（default）
    |                       |       |
    |                       |       +-- body.txt.twig（zurb_2）
    |                       |               |
    |                       |               +-- leadブロック（件名）
    |                       |               +-- contentブロック（本文）
    |                       |               +-- actionブロック（リンク）
    |                       |               +-- exceptionブロック（例外）
    |                       |
    |                       +-- NotificationEmail::getContext()
```

### データフロー図

```
[入力]                              [処理]                              [出力]

NotificationEmail                   body.txt.twig (default)             プレーンテキスト
├── email.subject                    └── body.txt.twig (zurb_2)         メール本文
├── content                              ├── leadブロック               ├── 件名テキスト
├── action_url/text                      ├── contentブロック            ├── 本文テキスト
└── exception                            ├── actionブロック             ├── "テキスト: URL"
        |                                └── exceptionブロック          └── 例外トレース
        +---> Twig Engine ---> プレーンテキスト出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| body.txt.twig（default） | `src/Symfony/Bridge/Twig/Resources/views/Email/default/notification/body.txt.twig` | テンプレート | デフォルトテーマテキストメールテンプレート（1行、zurb_2を継承） |
| body.txt.twig（zurb_2） | `src/Symfony/Bridge/Twig/Resources/views/Email/zurb_2/notification/body.txt.twig` | テンプレート | Zurb 2テーマテキストメールレイアウト本体（21行） |
| body.html.twig（default） | `src/Symfony/Bridge/Twig/Resources/views/Email/default/notification/body.html.twig` | テンプレート | 対になるHTML版テンプレート |
| NotificationEmail.php | `src/Symfony/Bridge/Twig/Mime/NotificationEmail.php` | ソース | 通知メールクラス。getTextTemplate()でテキストテンプレートパスを返す（281行） |
